package kiyut.sketsa.modules.symbollibrary.general;

import java.util.ResourceBundle;

/**
 * Star Symbol Option Panel
 * @author  Kiyut
 */
public class StarSymbolOptionPane extends javax.swing.JPanel {
    /** i18n support */
    protected static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.modules.symbollibrary.general.StarSymbolOptionPane");
    
    protected int numberOfPoints;
    protected double r1;
    protected double r2;
    
    /** StarSymbolOptionsPane constructor */
    public StarSymbolOptionPane() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        numberOfPointsField = new javax.swing.JTextField();
        r1Field = new javax.swing.JTextField();
        r2Field = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(bundle.getString("CTL_NumberOfPoints.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText(bundle.getString("CTL_R1.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 5);
        add(jLabel2, gridBagConstraints);

        jLabel3.setText(bundle.getString("CTL_R2.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 5);
        add(jLabel3, gridBagConstraints);

        numberOfPointsField.setColumns(10);
        add(numberOfPointsField, new java.awt.GridBagConstraints());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        add(r1Field, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        add(r2Field, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JTextField numberOfPointsField;
    private javax.swing.JTextField r1Field;
    private javax.swing.JTextField r2Field;
    // End of variables declaration//GEN-END:variables
 
    public void setValue(int numberOfPoints, double r1, double r2) {
        this.numberOfPoints = numberOfPoints;
        this.r1 = r1;
        this.r2 = r2;
        
        numberOfPointsField.setText(Integer.toString(numberOfPoints));
        r1Field.setText(Double.toString(r1));
        r2Field.setText(Double.toString(r2));
    }
    
    public void validateValue() {
        String str = numberOfPointsField.getText().trim();
        try {
            int i = Integer.parseInt(str);
            if (i < 3) {
                throw new RuntimeException("");
            }
            numberOfPoints = i;
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidNumberOfPoints.Text"));
        }
        
        str = r1Field.getText();
        try {
            r1 = Double.parseDouble(str);
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidR1.Text"));
        }
        
        str = r2Field.getText();
        try {
            r2 = Double.parseDouble(str);
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidR2.Text"));
        }
    }
    
    public int getNumberOfPoints() {
        return numberOfPoints;
    }
    
    public double getR1() {
        return r1;
    }
    
    public double getR2() {
        return r2;
    }
}
