package kiyut.sketsa.modules.symbollibrary.general;

import java.util.ResourceBundle;

/**
 * Polygon Symbol Option Panel
 * @author  Kiyut
 */
public class PolygonSymbolOptionPane extends javax.swing.JPanel {
    /** i18n support */
    protected static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.modules.symbollibrary.general.PolygonSymbolOptionPane");
    
    protected int numberOfPoints;
    protected double radius;
    
    /** Creates new form PolygonSymbolOptionPane */
    public PolygonSymbolOptionPane() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        numberOfPointsField = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        radiusField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(bundle.getString("CTL_NumberOfPoints.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        add(jLabel1, gridBagConstraints);

        numberOfPointsField.setColumns(10);
        add(numberOfPointsField, new java.awt.GridBagConstraints());

        jLabel2.setText(bundle.getString("CTL_Radius.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 5);
        add(jLabel2, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        add(radiusField, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField numberOfPointsField;
    private javax.swing.JTextField radiusField;
    // End of variables declaration//GEN-END:variables
    
    public void setValue(int numberOfPoints, double radius) {
        this.numberOfPoints = numberOfPoints;
        this.radius = radius;
        
        numberOfPointsField.setText(Integer.toString(numberOfPoints));
        radiusField.setText(Double.toString(radius));
    }
    
    public void validateValue() {
        String str = numberOfPointsField.getText().trim();
        try {
            int i = Integer.parseInt(str);
            if (i < 3) {
                throw new RuntimeException("");
            }
            numberOfPoints = i;
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidNumberOfPoints.Text"));
        }
        
        str = radiusField.getText();
        try {
            radius = Double.parseDouble(str);
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidRadius.Text"));
        }
    }
    
    public int getNumberOfPoints() {
        return numberOfPoints;
    }
    
    public double getRadius() {
        return radius;
    }
}
