package kiyut.sketsa.modules.symbollibrary.general;

import java.util.ResourceBundle;

/** Moon Symbol Option Panel
 *
 * @author  Kiyut
 */
public class MoonSymbolOptionPane extends javax.swing.JPanel {
    /** i18n support */
    protected static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.modules.symbollibrary.general.MoonSymbolOptionPane");
    
    protected double radius;
    protected double phase;
    
    /** Creates new form MoonSymbolOptionPane */
    public MoonSymbolOptionPane() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        radiusField = new javax.swing.JTextField();
        phaseField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(bundle.getString("CTL_Radius.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 5);
        add(jLabel1, gridBagConstraints);

        jLabel2.setText(bundle.getString("CTL_Phase.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        add(jLabel2, gridBagConstraints);

        radiusField.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        add(radiusField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(phaseField, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JTextField phaseField;
    private javax.swing.JTextField radiusField;
    // End of variables declaration//GEN-END:variables
 
    public void setValue(double phase,double radius) {
        this.phase = phase;
        this.radius = radius;
        
        radiusField.setText(Double.toString(radius));
        phaseField.setText(Double.toString(phase));
    }
    
    public void validateValue() {
        String str = phaseField.getText();
        try {
            double d = Double.parseDouble(str);
            if (d <= 0 || d > 1) {
                throw new RuntimeException("");
            }
            phase = d;
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidPhase.Text"));
        }
        
        str = radiusField.getText().trim();
        try {
            double d = Double.parseDouble(str);
            if (d <= 0) {
                throw new RuntimeException("");
            }
            radius = d;
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidRadius.Text"));
        }
    }
    
    public double getPhase() {
        return phase;
    }
    
    public double getRadius() {
        return radius;
    }
}
