package kiyut.sketsa.modules.symbollibrary.general;

import java.util.ResourceBundle;

/**
 * Atom Symbol Option Panel
 * @author  Kiyut
 */
public class AtomSymbolOptionPane extends javax.swing.JPanel {
    /** i18n support */
    protected static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.modules.symbollibrary.general.AtomSymbolOptionPane");
    
    protected double radius;
    
    /** Creates new form AtomSymbolOptionPane */
    public AtomSymbolOptionPane() {
        initComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jLabel1 = new javax.swing.JLabel();
        radiusField = new javax.swing.JTextField();

        setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(bundle.getString("CTL_Radius.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        add(jLabel1, gridBagConstraints);

        radiusField.setColumns(10);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(radiusField, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JTextField radiusField;
    // End of variables declaration//GEN-END:variables
    
    public void setValue(double radius) {
        this.radius = radius;
        
        radiusField.setText(Double.toString(radius));
    }
    
    public void validateValue() {
        String str = radiusField.getText();
        try {
            radius = Double.parseDouble(str);
        } catch (Exception ex) {
            throw new RuntimeException(bundle.getString("MSG_InvalidRadius.Text"));
        }
    }
    
    public double getRadius() {
        return radius;
    }
}
