package kiyut.sketsa.modules.symbollibrary.animal;

import java.awt.Color;
import java.awt.Shape;
import javax.swing.ImageIcon;
import kiyut.sketsa.util.GeomUtilities;

/**
 * Implementation of Rhino Symbol
 *
 * @author Kiyut
 */
public class RhinoSymbol extends AnimalSymbol {
    
    /** Creates a new instance of RhinoSymbol */
    public RhinoSymbol() {
        icon = new ImageIcon(getClass().getResource("/kiyut/sketsa/modules/symbollibrary/animal/rhino32.png"));
        tooltipText = "Rhino";
        strokeColor = null;
        fillColor = new Color(175,185,185);
    }
    
    @Override
    protected Shape getShape() {
        /* Create Shape */
        String pathString = "M 158.74153 69.5659 C 159.0 59.852814 157.44897 39.54364 156.15646 " +
        "35.128586 C 147.88438 18.351425 115.82994 7.166641 103.93875 8.343994 C 92.56464 15.113724 " + 
        "67.48977 11.58168 60.510185 7.4609833 C 56.891167 9.227005 47.06806 15.408066 47.06806 " + 
        "15.408066 C 47.06806 15.408066 40.605446 8.638336 40.346916 8.638336 C 27.680286 13.936386 " + 
        "45.258514 29.536194 32.850346 37.18892 C 30.265282 33.65689 27.163265 27.47583 27.163265 " + 
        "27.47583 C 24.319736 27.181519 21.993202 40.720963 21.993202 40.720963 C 21.993202 40.720963 " + 
        "13.462593 30.713547 11.9115715 28.653183 C 7.0 38.66063 14.496613 49.55104 19.408165 " + 
        "54.849075 C 19.666672 57.79245 19.925186 59.26413 20.183674 61.913147 C 26.646267 73.097946 " + 
        "46.809532 65.73953 57.149673 56.02643 C 80.15647 60.441483 77.31294 78.39601 72.40137 " + 
        "89.28638 C 73.95239 103.12024 87.13606 101.059875 91.272125 97.23346 C 92.82315 88.40338 " + 
        "93.081635 81.928055 91.78912 78.69028 C 93.081635 74.56961 94.63265 73.097946 97.9932 " + 
        "70.44891 C 105.74832 69.27156 114.27893 70.15457 121.258514 73.39226 C 130.56464 78.39601 " + 
        "122.29253 90.16937 118.93198 93.407166 C 116.60544 103.41452 125.65306 104.003265 129.78912 " + 
        "103.12024 C 133.27893 96.86557 135.2177 90.02228 136.7687 82.811066 C 142.71428 88.99213 " + 
        "137.28572 98.116455 135.47621 103.12024 C 138.57825 112.83334 148.983 105.91641 150.92178 " + 
        "99.29385 C 155.57484 86.490234 142.97281 78.39601 151.11566 69.27156 z";
        
        Shape  shape = GeomUtilities.createShape(pathString);
        
        return shape;
    }
    
}
