package kiyut.sketsa.modules.symbollibrary.animal;

import java.awt.Color;
import java.awt.Shape;
import javax.swing.ImageIcon;
import kiyut.sketsa.util.GeomUtilities;

/** Implementation of Dolphin Symbol
 *
 * @author Kiyut
 */
public class DolphinSymbol extends AnimalSymbol {
    
    /** Creates a new instance of DolphinSymbol */
    public DolphinSymbol() {
        icon = new ImageIcon(getClass().getResource("/kiyut/sketsa/modules/symbollibrary/animal/dolphin32.png"));
        tooltipText = "Dolphin";
        strokeColor = null;
        fillColor = new Color(50,100,255);
    }
    
    @Override
    protected Shape getShape() {
        /* Create Shape */
        String pathString = "M 7.5 74.0 C 10.5 70.25 19.0 65.5 32.5 69.5 C 35.75 60.75 71.25 34.25 84.5 " +
                "30.75 C 88.25 23.75 92.0 13.5 94.5 7.5 C 101.0 10.75 108.5 19.75 114.75 28.5 C 138.0 35.5 " +
                "148.25 43.0 147.75 60.25 C 149.5 64.0 152.0 67.5 155.5 71.25 C 154.25 75.25 151.25 75.0 " +
                "151.25 75.0 C 145.75 72.0 134.0 67.25 126.0 66.5 C 122.75 73.25 113.75 74.0 108.5 74.75 C " +
                "110.0 68.25 107.25 61.75 107.25 61.75 C 87.5 53.75 56.75 64.5 41.5 76.75 C 43.25 88.0 39.0 " +
                "93.25 35.0 95.25 C 30.25 89.5 27.75 87.5 25.75 83.0 z";
        
        Shape  shape = GeomUtilities.createShape(pathString);
        
        return shape;
    }
}
