package kiyut.sketsa.modules.symbollibrary.animal;

import java.awt.Color;
import java.awt.Shape;
import javax.swing.ImageIcon;
import kiyut.sketsa.util.GeomUtilities;

/**
 * Implementation of Butterfly Symbol 
 *
 * @author Kiyut
 */
public class ButterflySymbol extends AnimalSymbol {
    
    /** Creates a new instance of ButterflySymbol */
    public ButterflySymbol() {
        icon = new ImageIcon(getClass().getResource("/kiyut/sketsa/modules/symbollibrary/animal/butterfly32.png"));
        tooltipText = "Butterfly";
        strokeColor = null;
        fillColor = new Color(255,70,210);
    }
    
    @Override
    protected Shape getShape() {
        /* Create Shape */
        String pathString = "M 78.25 41.875 C 68.375 35.0 63.375 24.375 61.125 22.125 C 57.875 23.625 " +
        "70.125 38.0 75.75 42.625 C 73.5 44.125 74.0 47.25 74.0 47.25 C 57.125 20.0 25.375 9.375 17.0 " +
        "14.25 C 8.625 20.0 12.875 29.0 21.125 34.25 C 23.0 37.75 22.25 43.5 21.875 46.25 C 24.125 " +
        "48.0 25.5 51.0 25.25 53.5 C 26.625 57.625 30.75 60.375 36.125 60.75 C 32.625 64.125 28.125 " +
        "69.75 28.5 73.0 C 30.75 77.625 31.875 81.375 30.875 86.125 C 32.875 94.25 43.0 103.5 54.875 " +
        "103.625 C 65.125 104.125 73.0 88.375 76.5 76.375 C 76.5 82.5 76.25 94.25 78.375 94.5 C " +
        "80.625 95.0 80.25 82.25 80.375 76.5 C 91.625 117.25 118.125 103.75 125.875 86.25 C 124.75 " +
        "78.875 126.75 76.375 128.25 73.0 C 129.0 70.375 123.5 62.625 120.5 60.5 C 128.125 60.5 " +
        "130.875 55.0 131.25 53.5 C 131.25 49.25 133.875 46.5 134.875 45.875 C 134.125 41.5 134.25 " +
        "37.0 135.625 34.0 C 148.0 26.875 145.5 14.875 137.5 13.125 C 115.5 12.0 94.375 29.125 82.125 " +
        "47.375 C 82.375 44.625 82.0 43.5 80.125 42.75 C 86.875 37.75 98.25 24.125 95.625 21.875 C " +
        "88.875 33.25 78.5 41.625 78.5 41.625 z";
        
        Shape shape = GeomUtilities.createShape(pathString);
        
        return shape;
    }
    
}
