package kiyut.sketsa.modules.symbollibrary;

import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import kiyut.sketsa.api.symbollibrary.Symbol;
import kiyut.sketsa.canvas.CanvasTransferable;

/** Symbol DnD support
 *
 * @author Kiyut
 */
public class SymbolTransferHandler extends TransferHandler {
    
    /** Creates a new instance of SymbolTransferHandler */
    public SymbolTransferHandler() {
    }
 
    @Override
    public int getSourceActions(JComponent comp) {
        return TransferHandler.COPY;
    }
    
    @Override
    protected Transferable createTransferable(JComponent comp) {
        if (!(comp instanceof JList)) {
            return null;
        }
        
        @SuppressWarnings("unchecked")
        JList<Symbol> list = (JList<Symbol>)comp;
        int index = list.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        
        Symbol symbol = list.getModel().getElementAt(index);
        
        SymbolTransferData data = new SymbolTransferData(symbol);
        Transferable transferable = new CanvasTransferable(data);
        
        return transferable;
    }
}
