package kiyut.sketsa.modules.symbollibrary;


import java.awt.Point;
import java.awt.datatransfer.Transferable;
import javax.swing.JComponent;
import kiyut.sketsa.api.symbollibrary.Symbol;
import kiyut.sketsa.canvas.CanvasTransferData;
import kiyut.sketsa.canvas.VectorCanvas;

/** Symbol Library DnD support
 *
 * @author Kiyut
 */
public class SymbolTransferData extends CanvasTransferData {
    
    /** Creates a new instance of SymbolTransferData */
    public SymbolTransferData(Object transferData) {
        super(transferData);
    }
 
    /** {@inheritDoc} */
    public boolean importData(JComponent comp, Transferable t) {
        if (transferData == null) { return false;}
        
        boolean imported = false;
        
        VectorCanvas canvas = (VectorCanvas)comp;
        
        // For Java 1.5 it is preferable to use comp.getMousePosition()
        //Point p = comp.getMousePosition();
        Point p = canvas.getDropLocation();
        if (p == null) { return imported; }
        
        try {
            Symbol symbol = (Symbol)transferData;
            symbol.insertSymbol(canvas,p);
            imported = true;
        } catch (Exception ex) {
            imported = false;
        }
        
        return imported;
    }
}
