package kiyut.sketsa.modules.symbollibrary;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import kiyut.sketsa.api.symbollibrary.Symbol;

/**
 * Symbol Renderer for the SymbolLibraryPane
 * @author Kiyut
 */
public class SymbolRenderer extends DefaultListCellRenderer {

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);

        //Set the icon and text.  If icon was null, say so.
        Symbol symbol = (Symbol)list.getModel().getElementAt(index);
        setIcon(symbol.getIcon());
        setToolTipText(symbol.getTooltipText());
        
        return this;
    }
}
