package kiyut.sketsa.modules.symbollibrary;

import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

/**
 * Action which shows <code>SymbolLibraryTopComponent</code> component.
 */
public class SymbolLibraryTopComponentAction extends CallableSystemAction {
    
    @Override
    public void performAction() {
        TopComponent tc = SymbolLibraryTopComponent.findInstance();
        tc.open();
        tc.requestActive();
    }
        
    @Override
    public String getName() {
        return NbBundle.getMessage(SymbolLibraryTopComponentAction.class, "CTL_SymbolLibraryTopComponentAction");
    }
    
    
    @Override
    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
    
    @Override
    protected boolean asynchronous() {
        return false;
    }
    
}
