package kiyut.sketsa.modules.symbollibrary;

import java.awt.BorderLayout;
import java.io.Serializable;
import kiyut.sketsa.api.symbollibrary.SymbolLibrary;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/**
 * <code>TopComponent</code> which display <code>SymbolLibraryPane</code>
 */
public class SymbolLibraryTopComponent extends TopComponent {
    
    private static SymbolLibraryTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    
    private static final String PREFERRED_ID = "SymbolLibraryTopComponent";
    
    private SymbolLibraryPane symbolLibraryPane;
    
    private SymbolLibraryTopComponent() {
        initComponents();
        setName(NbBundle.getMessage(SymbolLibraryTopComponent.class, "CTL_SymbolLibraryTopComponent"));
        setToolTipText(NbBundle.getMessage(SymbolLibraryTopComponent.class, "HINT_SymbolLibraryTopComponent"));
//        setIcon(Utilities.loadImage(ICON_PATH, true));
        
        initCustomComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        setLayout(new java.awt.BorderLayout());

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables
    
    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized SymbolLibraryTopComponent getDefault() {
        if (instance == null) {
            instance = new SymbolLibraryTopComponent();
        }
        return instance;
    }
    
    /**
     * Obtain the SymbolLibraryTopComponent instance. Never call {@link #getDefault} directly!
     * @return 
     */
    public static synchronized SymbolLibraryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(ErrorManager.WARNING, "Cannot find SymbolLibrary component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof SymbolLibraryTopComponent) {
            return (SymbolLibraryTopComponent)win;
        }
        ErrorManager.getDefault().log(ErrorManager.WARNING, "There seem to be multiple components with the '" + PREFERRED_ID + "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }
    
    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }
    
    @Override
    public Object writeReplace() {
        return new ResolvableHelper();
    }
    
    @Override
    protected String preferredID() {
        return PREFERRED_ID;
    }
    
    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return SymbolLibraryTopComponent.getDefault();
        }
    }
    
    private void initCustomComponents() {
        //symbolLibraryPane = new SymbolLibraryPane();
        
        symbolLibraryPane = (SymbolLibraryPane)Lookup.getDefault().lookup(SymbolLibrary.class);
        this.add(BorderLayout.CENTER,symbolLibraryPane);
    }
    
}
