package kiyut.sketsa.api.symbollibrary;

import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import kiyut.sketsa.canvas.VectorCanvas;

/**
 * Symbol Item 
 * @author Kiyut
 */
public interface Symbol {
    
    /** Return category 
     * @return category
     */
    public String getCategory();
    
    /** Return icon use for display in the SymbolLibrary.
     * @return Icon
     */
    public Icon getIcon();
    
    /** Return String use for display in the SymbolLibrary tooltip.
     * @return String
     */
    public String getTooltipText();
    
    /** Delegate to Symbol Implementation. 
     * param parentComponent determines the Frame in which the dialog is displayed; 
     *      if null, or if the parentComponent has no Frame, a default Frame is used
     */
    public void showOptionDialog(Component parentComponent);
    
    /** 
     * Insert Symbol to the Canvas at specified location.
     * @param canvas VectorCanvas
     * @param location The location where the insertion should take place
     */
    public void insertSymbol(VectorCanvas canvas, Point location);
}
