package kiyut.sketsa.api.symbollibrary;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import kiyut.swing.button.ColorChooserButton;

/**
 * Default Symbol Option Panel.
 * Currently it only provided Stroke And Fill Color
 * @author  Kiyut
 */
public class DefaultSymbolOptionPane extends javax.swing.JPanel {
    /** i18n support */
    private static ResourceBundle bundle = ResourceBundle.getBundle("kiyut.sketsa.api.symbollibrary.DefaultSymbolOptionPane");
    
    /** Stroke Color */
    protected Color strokeColor;
    
    /** Fill Color */
    protected Color fillColor;
    
    /**
     * Creates new form DefaultSymbolOptionPane
     */
    public DefaultSymbolOptionPane() {
        initComponents();
        initCustomComponents();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;
        javax.swing.JLabel jLabel10;
        javax.swing.JLabel jLabel2;
        javax.swing.JLabel jLabel3;
        javax.swing.JLabel jLabel9;
        javax.swing.JPanel jPanel1;
        javax.swing.JPanel jPanel2;

        jPanel1 = new javax.swing.JPanel();
        strokeNoneRadio = new javax.swing.JRadioButton();
        strokeColorButton = new ColorChooserButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        fillNoneRadio = new javax.swing.JRadioButton();
        fillColorButton = new ColorChooserButton();
        jLabel3 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jPanel1.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("CTL_Stroke.Text")), javax.swing.BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel1.add(strokeNoneRadio, gridBagConstraints);

        strokeColorButton.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel1.add(strokeColorButton, gridBagConstraints);

        jLabel2.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel2, gridBagConstraints);

        jLabel9.setText(bundle.getString("CTL_Color.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel1.add(jLabel9, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jPanel1, gridBagConstraints);

        jPanel2.setLayout(new java.awt.GridBagLayout());

        jPanel2.setBorder(javax.swing.BorderFactory.createCompoundBorder(javax.swing.BorderFactory.createTitledBorder(bundle.getString("CTL_Fill.Text")), javax.swing.BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        jPanel2.add(fillNoneRadio, gridBagConstraints);

        fillColorButton.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 0, 0, 0);
        jPanel2.add(fillColorButton, gridBagConstraints);

        jLabel3.setText(bundle.getString("CTL_None.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel2.add(jLabel3, gridBagConstraints);

        jLabel10.setText(bundle.getString("CTL_Color.Text"));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 0, 5);
        jPanel2.add(jLabel10, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jPanel2, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton fillColorButton;
    private javax.swing.JRadioButton fillNoneRadio;
    private javax.swing.JButton strokeColorButton;
    private javax.swing.JRadioButton strokeNoneRadio;
    // End of variables declaration//GEN-END:variables
    
    protected void initCustomComponents() {
        strokeNoneRadio.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                strokeColor = null;
                ((ColorChooserButton)strokeColorButton).setColor(null);
            }
        });
        
        fillNoneRadio.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                fillColor = null;
                ((ColorChooserButton)fillColorButton).setColor(null);
            }
        });
        
        strokeColorButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                strokeColor = ((ColorChooserButton)strokeColorButton).getColor();
                if (strokeColor != null) {
                    strokeNoneRadio.setSelected(false);
                }
            }
        });
        
        fillColorButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent evt) {
                fillColor = ((ColorChooserButton)fillColorButton).getColor();
                if (fillColor != null) {
                    fillNoneRadio.setSelected(false);
                }
            }
        });
        
        strokeColorButton.setFocusPainted(false);
        fillColorButton.setFocusPainted(false);
    }
    
    /* Return this Component resource bundle
     *@return ResourceBundle
     */
    public ResourceBundle getResourceBundle() {
        return bundle;
    }
    
    /** @deprecated replaced with setValue(Color,Color) */
    @Deprecated 
    public void setValue(Color fillColor) {
        this.fillColor = fillColor;
        
        ((ColorChooserButton)fillColorButton).setColor(fillColor);
    }
    
    public void setValue(Color strokeColor, Color fillColor) {
        this.strokeColor = strokeColor;
        this.fillColor = fillColor;
        
        if (strokeColor == null) {
            strokeNoneRadio.setSelected(true);
        } else {
            ((ColorChooserButton)strokeColorButton).setColor(strokeColor);
        }
        
        if (fillColor == null) {
            fillNoneRadio.setSelected(true);
        } else {
            ((ColorChooserButton)fillColorButton).setColor(fillColor);
        }
    }
    
    public Color getFillColor() {
        return fillColor;
    }
    
    public Color getStrokeColor() {
        return strokeColor;
    }
}
