package kiyut.sketsa.api.symbollibrary;

import java.awt.Component;
import java.awt.Point;
import javax.swing.Icon;
import kiyut.sketsa.canvas.VectorCanvas;


/**
 * Abstract Implementation of Symbol.
 * The methods in this class are empty. This class is provided as a convenience 
 * for easily creating Symbol by extending this class.
 * @author Kiyut
 */
public abstract class AbstractSymbol implements Symbol {
   
    @Override
    public Icon getIcon() {
        return null;
    }
    
    @Override
    public String getCategory() {
        return "General";
    }
    
    @Override
    public String getTooltipText() {
        return "Symbol";
    }
    
    @Override
    public void showOptionDialog(Component parentComponent) {
        /* do nothing */
    }
    
    @Override
    public void insertSymbol(VectorCanvas canvas, Point location) {
        /* do nothing */
    }
}

