package kiyut.sketsa.modules.pdfexport.actions;

import java.awt.EventQueue;
import kiyut.sketsa.actions.AbstractEditorAction;
import kiyut.sketsa.canvas.CanvasModel;
import kiyut.sketsa.canvas.VectorCanvas;
import org.openide.awt.ActionID;
import org.openide.awt.ActionReference;
import org.openide.awt.ActionRegistration;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;


/**
 * Action that Show Export As PDF Dialog
 * @author Kiyut
 */
@ActionID(id = "kiyut.sketsa.actions.ExportAsPDFAction", category = "File")
@ActionRegistration(displayName = "#CTL_ExportAsPDFAction", lazy = false)
@ActionReference(path = "Menu/File/Export", position = 200)
public class ExportAsPDFAction extends AbstractEditorAction {
    
    @Override
    public void performAction() {
        if (editorCookie == null) {
            return;
        }
        
        EventQueue.invokeLater(() -> {
            VectorCanvas canvas = editorCookie.getVectorCanvas();
            
            java.awt.Frame mainFrame = WindowManager.getDefault().getMainWindow();
            
            CanvasModel canvasModel = canvas.getModel();
            java.awt.geom.Rectangle2D rect = new java.awt.geom.Rectangle2D.Double(0,0,canvasModel.getSVGWidth(),canvasModel.getSVGHeight());
            
            ExportAsPDFWindow exportDialog = new ExportAsPDFWindow(mainFrame,true);
            exportDialog.setSVGDocument(canvas.getSVGDocument());
            exportDialog.setArea(rect);
            exportDialog.pack();
            exportDialog.setLocationRelativeTo(mainFrame);
            exportDialog.setVisible(true);
            exportDialog = null;
        });
    }
    
    @Override
    public String getName() {
        return NbBundle.getMessage(ExportAsPDFAction.class, "CTL_ExportAsPDFAction");
    }
    
}
