package kiyut.sketsa.modules.extratool;

import kiyut.sketsa.windows.toolbox.AbstractToolAction;
import org.openide.util.NbBundle;

/** Action wrapper for {@link kiyut.sketsa.modules.extratool.RoundRectangleTool} which is used by Toolbox, aka Toolbox Item
 *
 * @author KIYUT
 */
public class RoundRectangleToolAction extends AbstractToolAction {
    
    /**
     * Creates a new instance of RoundRectangleToolAction
     */
    public RoundRectangleToolAction() {
        tool = new RoundRectangleTool();
    }
    
    @Override
    public String getName() {
        return NbBundle.getMessage(RoundRectangleToolAction.class, "CTL_RoundRectangleToolAction");
    }
    
    @Override
    protected String iconResource() {
        return NbBundle.getMessage(RoundRectangleToolAction.class, "ICON_RoundRectangleToolAction");
    }
}
